#! /bin/bash
##Launches an instance of the Native Client Launcher
# Get the location of the script.
REALDIR=$(cd "$( dirname "${BASH_SOURCE[0]}")" && pwd)
JAVACMD="${REALDIR}/runtime/bin/./java"

if [[ "$(getconf LONG_BIT)" != "64" ]]; then
	echo "32-bit OS detected. Using installed JRE instead of bundled version."
	if [[ -f "${JAVACMD}" ]]; then
		mv "${REALDIR}/runtime" "${REALDIR}/runtime_64"
	fi
	JAVACMD="java"
elif [[ ! -f "${JAVACMD}" ]]; then
	echo "runtime directory not found. Using installed JRE instead of bundled version."
	JAVACMD="java"
fi

"${JAVACMD}" -jar "${REALDIR}/app/native-launcher.jar" $@ >/dev/null 2>&1 &
